/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  clk_gen
//
// DESCRIPTION OF MODULE:
//      clock generator with jitter
//
// DESCRIPTION OF PORTS:           (please see header)
// DESCRIPTION OF PARAMETER:       (please see header)
//
// this file was generated by 'sca_xml2cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_FRONTEND_CLK_GEN_H_
#include "clk_gen.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct clk_gen::states
{
	bool initialized;
	bool state;

    states()
    {
    	initialized=false;
    	state=false;
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
clk_gen::states& clk_gen::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// SC_METHOD clk_method
//////////////////////////////////////////////
void clk_gen::clk_method()
{
	if(!s.initialized)
	{
		s.initialized=true;
		s.state=p.init;
		clk.write(s.state);

		if(p.start!=SC_ZERO_TIME)
		{
			next_trigger(p.start);
			return;
		}
	}

	s.state=!s.state;
	clk.write(s.state);

	sc_time next_edge;

	if(p.jitter>0.0)
	{
		double rnd = 2.0*((double)std::rand()) / ((double)RAND_MAX) - 1.0;

		next_edge=((1.0+rnd*p.jitter/100.0)*p.period)/2;
	}
	else
	{
		next_edge=p.period/2;
	}

	next_trigger(next_edge);

}


#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

