/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: sensor
//
// MODULE NAME:  vibration_sensor
//
// DESCRIPTION OF MODULE:
//      /* Vibration sensor */
//
// DESCRIPTION OF PORTS:
// x_in of type double
//      /* Displacement [m] */
// v_out of type double
//      /* Sensor output voltage [V] */
// DESCRIPTION OF PARAMETER:
// k of type double
//      /* Conversion factor from vibration velocity to output voltage [V s / m] */
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_SENSOR_VIBRATION_SENSOR_H_
#define _VIBRATION_SENSOR_SENSOR_VIBRATION_SENSOR_H_

#include <systemc-ams.h>


namespace vibration_sensor_namespace
{

SCA_TDF_MODULE(vibration_sensor)
{
    // sca tdf ports
    sca_tdf::sca_in<double  > x_in;
    sca_tdf::sca_out<double  > v_out;

    // parameters
    struct params
    {
        double  k;

        params()
        {
            k = 1.0;
        }
    } p;


    //methods
    void processing();


    // constructor
    vibration_sensor(sc_core::sc_module_name nm, params pa = params() ) : x_in("x_in"),
                                                       v_out("v_out"),
                                                       p(pa),
                                                       s(create_states())
    {
        accept_attribute_changes();



    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_SENSOR_VIBRATION_SENSOR_CPP_
#define _VIBRATION_SENSOR_SENSOR_VIBRATION_SENSOR_CPP_
#include "vibration_sensor.cpp"
#endif
#endif
